function Figure5D()
%The script plots the data from Figure 5D.

% Percentage of postF particles after 2h (column 1) and 24h (column 2).
pre_post = [8.7511 29.116 ; 2.4358 15.6082 ; 2.8796 29.8467];

% Percentage of filaments defined by particles >1um with L/W > 2.
filaments = 100 - [22.2605 62.713 ; 31.0757 75.8172 ; 38.2589 75.4088];

q = [0 1];
plot(q,pre_post,'Color',[.7 .7 .7]); hold on;
plot(q,mean(pre_post,1),'k'); ylim([0 40]); xlim([-.5 1.5]);
xticks([0 1]);
xticklabels({'2hr','24hr'});
ylabel('Precent post-F positive');

figure;
plot(q,filaments,'Color',[.7 .7 .7]); hold on;
plot(q,mean(filaments,1),'k'); ylim([0 80]); xlim([-.5 1.5]);
xticks([0 1]);
xticklabels({'2hr','24hr'});
ylabel('Precent filamentous particles');

[h,p] = ttest(pre_post(:,1),pre_post(:,2));
disp(['p-value for precent post-F comparison: ',num2str(p)]);
[h,p] = ttest(filaments(:,1),filaments(:,2));
disp(['p-value for percent filamentous comparison: ',num2str(p)]);